/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinSplitArrowButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public final class SkinSplitPaneDivider
extends BasicSplitPaneDivider
implements SwingConstants {
    protected Skin skin = SkinLookAndFeel.getSkin();
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public SkinSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new DividerLayout());
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
        this.splitPane.setDividerSize(newSize);
    }

    public void paint(Graphics g) {
        Rectangle bounds;
        Dimension size = this.getSize();
        this.skin.getSplitPane().paintGutter(g, this.splitPane, size);
        if (this.leftButton != null) {
            bounds = this.leftButton.getBounds();
            Graphics glb = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            this.leftButton.paint(glb);
        }
        if (this.rightButton != null) {
            bounds = this.rightButton.getBounds();
            Graphics grb = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            this.rightButton.paint(grb);
        }
        this.skin.getSplitPane().paintThumb(g, this.splitPane, size);
    }

    protected JButton createLeftOneTouchButton() {
        int button_direction = 5;
        if (this.orientation == 1) {
            button_direction = 7;
        }
        SkinSplitArrowButton b = new SkinSplitArrowButton(button_direction);
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        this.updateDividerSize(((JComponent)b).getPreferredSize());
        return b;
    }

    protected JButton createRightOneTouchButton() {
        int button_direction = 1;
        if (this.orientation == 1) {
            button_direction = 3;
        }
        SkinSplitArrowButton b = new SkinSplitArrowButton(button_direction);
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        this.updateDividerSize(((JComponent)b).getPreferredSize());
        return b;
    }

    protected void updateDividerSize(Dimension d) {
        int buttonSize = this.orientation == 1 ? d.width : d.height;
        int sbSize = this.splitPane.getDividerSize();
        if (sbSize < buttonSize) {
            this.splitPane.setDividerSize(buttonSize);
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        public void layoutContainer(Container c) {
            if (SkinSplitPaneDivider.this.leftButton != null && SkinSplitPaneDivider.this.rightButton != null && c == SkinSplitPaneDivider.this) {
                Dimension leftSize = SkinSplitPaneDivider.this.leftButton.getPreferredSize();
                Dimension rightSize = SkinSplitPaneDivider.this.rightButton.getPreferredSize();
                if (SkinSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SkinSplitPaneDivider.this.getInsets();
                    if (insets == null) {
                        insets = NO_INSETS;
                    }
                    if (SkinSplitPaneDivider.this.orientation == 0) {
                        int blockSize = SkinSplitPaneDivider.this.getDividerSize() - (insets.left + insets.right);
                        int y = (c.getSize().height - blockSize) / 2;
                        SkinSplitPaneDivider.this.leftButton.setBounds(insets.left + leftSize.width, y, leftSize.width, leftSize.height);
                        SkinSplitPaneDivider.this.rightButton.setBounds(insets.left * 2 + leftSize.width + rightSize.width, y, rightSize.width, rightSize.height);
                    } else {
                        int blockSize = SkinSplitPaneDivider.this.getDividerSize() - (insets.top + insets.bottom);
                        int x = (c.getSize().width - blockSize) / 2;
                        SkinSplitPaneDivider.this.leftButton.setBounds(x, insets.top + leftSize.height, leftSize.width, leftSize.height);
                        SkinSplitPaneDivider.this.rightButton.setBounds(x, insets.top * 2 + leftSize.height + rightSize.height, rightSize.width, rightSize.height);
                    }
                } else {
                    SkinSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SkinSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }
}

